%{

/* 

Ce fichier indique a l'outil "yacc" comment generer l'analyseur 
syntaxique du langage. Il contient donc :

  - une decription de la grammaire du langage 
  - un description des actions que doit effectuer l'analyseur lorsqu'il 
    "reconnait" une regle de la grammaire (par exemple afficher un message, 
    effectuer un calcul, construire un fragment d'arbre abstrait, etc.). 
    Sur l'exemple l'analyseur devra evaluer l'expression booleenne qu'il 
    est en train de reconnaitre (calculer sa valeur).

*/


int val ; 
%}

%token True
%token False
%token Erreur_lexicale


%start EXP_BOOL 	

%%

EXP_BOOL : E {val=$1;YYACCEPT;}	
  ;


E : E '+' T {$$=$1 || $3;} 
  | T {$$=$1;}
  ;


T : T '*' F {$$=$1 && $3;} 	
  | F {$$=$1;}		
  ;


F : '(' E ')' {$$=$2;}	
  | True {$$=1;}	
  | False {$$=0;}	
  ;
 

%%

#include "lex.yy.c"
